/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.event;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.redpxnda.nucleus.registry.particles.DynamicParticle;
import com.redpxnda.nucleus.util.RenderUtil;
import com.redpxnda.respawnobelisks.registry.ModRegistries;
import com.redpxnda.respawnobelisks.registry.block.entity.RespawnObeliskBER;
import com.redpxnda.respawnobelisks.registry.particle.ChargeIndicatorParticle;
import com.redpxnda.respawnobelisks.util.RenderUtils;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientTextureStitchEvent;
import dev.architectury.registry.client.particle.ParticleProviderRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {
    protected static void onTextureStitch(TextureAtlas atlas, Consumer<ResourceLocation> spriteAdder) {
        if (!atlas.m_118330_().equals((Object)TextureAtlas.f_118259_)) {
            return;
        }
        spriteAdder.accept(RespawnObeliskBER.RUNES);
        RenderUtils.getThemeTextures().forEach((str, loc) -> spriteAdder.accept((ResourceLocation)loc));
    }

    public static void onClientSetup(Minecraft mc) {
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)ModRegistries.RESPAWN_OBELISK_BE.get()), RespawnObeliskBER::new);
    }

    public static void init() {
        ClientTextureStitchEvent.PRE.register(ClientEvents::onTextureStitch);
        ClientLifecycleEvent.CLIENT_SETUP.register(ClientEvents::onClientSetup);
    }

    public static void registerParticleProviders() {
        ParticleProviderRegistry.register(ModRegistries.DEPLETE_RING_PARTICLE, set -> new DynamicParticle.Provider((SpriteSet)set, setup -> setup.m_107257_(50), tick -> {
            tick.scale = (float)((double)tick.scale + 0.25 / (double)((float)tick.getAge() / 4.0f + 1.0f));
            if (tick.getAge() > 38) {
                tick.alpha = (float)((double)tick.alpha - 0.05);
            }
        }, (render, vecs) -> RenderUtil.rotateVectors((Vector3f[])vecs, (Quaternion)Vector3f.f_122223_.m_122240_(90.0f))));
        ParticleProviderRegistry.register(ModRegistries.CHARGE_INDICATOR_PARTICLE, ChargeIndicatorParticle.Provider::new);
    }
}

